const colorButtons = {
    'top-left': new Audio('https://s3.amazonaws.com/freecodecamp/simonSound1.mp3'),
    'top-right': new Audio('https://s3.amazonaws.com/freecodecamp/simonSound2.mp3'),
    'bottom-left': new Audio('https://s3.amazonaws.com/freecodecamp/simonSound3.mp3'),
    'bottom-right': new Audio('https://s3.amazonaws.com/freecodecamp/simonSound4.mp3'),
  };
  
  const gameSequence = [];
  let playerSequence = [];
  let score = 0;
  
  const startButton = document.getElementById('start-button');
  const scoreDisplay = document.getElementById('score');
  const buttons = document.querySelectorAll('.color-button');
  
  startButton.addEventListener('click', startGame);
  
  buttons.forEach(button => {
    button.addEventListener('click', handlePlayerInput);
  });
  
  function startGame() {
    gameSequence.length = 0;
    playerSequence.length = 0;
    score = 0;
    updateScore();
    nextRound();
  }
  
  function nextRound() {
    disableButtons();
    playerSequence.length = 0;
    gameSequence.push(randomColor());
    playSequence();
  }
  
  function randomColor() {
    const colors = Object.keys(colorButtons);
    return colors[Math.floor(Math.random() * colors.length)];
  }
  
  function playSequence() {
    let delay = 0;
    gameSequence.forEach((color, index) => {
      setTimeout(() => activateButton(color), delay);
      delay += 800;
    });
    setTimeout(() => enableButtons(), delay);
  }
  
  function activateButton(color) {
    const button = document.getElementById(color);
    button.classList.add('active');
    colorButtons[color].play();
    setTimeout(() => button.classList.remove('active'), 400);
  }
  
  function handlePlayerInput(event) {
    const color = event.target.id;
    playerSequence.push(color);
    activateButton(color);
  
    if (!checkPlayerInput()) {
      alert('Game Over! Your score: ' + score);
      disableButtons();
      return;
    }
  
    if (playerSequence.length === gameSequence.length) {
      score++;
      updateScore();
      setTimeout(nextRound, 1000);
    }
  }
  
  function checkPlayerInput() {
    return playerSequence.every((color, index) => color === gameSequence[index]);
  }
  
  function updateScore() {
    scoreDisplay.textContent = `Score: ${score}`;
  }
  
  function enableButtons() {
    buttons.forEach(button => button.disabled = false);
  }
  
  function disableButtons() {
    buttons.forEach(button => button.disabled = true);
  }